#ifndef _TTIME_H_
#define _TTIME_H_

#include <sys/time.h>
#include <sys/types.h>

struct ttime {
	int tt_sec;
	long tt_nsec;
#define TT_NNSEC	(1000000000)
};

#define TTIME_TOTS(x)	((struct timespec){ (x).tt_sec, (x).tt_nsec })
#define TTIME_TOTV(x)	((struct timeval){ (x).tt_sec, (x).tt_usec / 1000 })

#define TTIME_FMTS(x)	((struct ttime){ (x).tv_sec, (x).tv_nsec })
#define TTIME_FMTV(x)	((struct ttime){ (x).tv_sec, (x).tv_usec * 1000 })

#define TTIME_INIT()	((struct ttime){ 0, 0})
#define TTIME_MAKE(s, n)	((struct ttime){ (s), (n)})

#define TTIME_TOFL(x)	((float)(x).tt_sec + (float)(x).tt_nsec / TT_NNSEC)
#define TTIME_TODB(x)	((double)(x).tt_sec + (double)(x).tt_nsec / TT_NNSEC)

struct ttime tt_add(struct ttime, struct ttime);
struct ttime tt_sub(struct ttime, struct ttime);
struct ttime tt_mul(struct ttime, struct ttime);
int tt_cmp(struct ttime, struct ttime);

#endif /* _TTIME_H_ */
