#include <stdio.h>
#include <ttime_priv.h>

int regress_reduce(void);
int regress_mul(void);

struct {
	int (*test)(void);
	char *name;
} regress_tests[] = {
	{ regress_reduce, "reduce" },
	{ regress_mul, "mul" }
};

int
main()
{
	int i;
	int r;
	int maxl;
	int ret;

	maxl = 0;
	for (i = 0; i < sizeof regress_tests / sizeof *regress_tests; i++)
		if ((r = strlen(regress_tests[i].name)) > maxl)
			maxl = r;

	ret = 0;
	for (i = 0; i < sizeof regress_tests / sizeof *regress_tests; i++) {
		r = regress_tests[i].test();
		printf("%s:%*s%s (%d)\n", regress_tests[i].name, maxl
		    - strlen(regress_tests[i].name) + 1, "",
		    (r == 0 ? "passed" : "failed"), r);
		if (r != 0)
			ret = 0;
	}

	return 0;
}

int
regress_reduce()
{
	if (tt_cmp(tt_reduce(TTIME_MAKE(0, 5)), TTIME_MAKE(0, 5)))
		return 1;

	if (tt_cmp(tt_reduce(TTIME_MAKE(0, -5)), TTIME_MAKE(0, -5)))
		return 2;

	if (tt_cmp(tt_reduce(TTIME_MAKE(-1, 5)), TTIME_MAKE(0, 5 - TT_NNSEC)))
		return 3;

	if (tt_cmp(tt_reduce(TTIME_MAKE(1, -5)), TTIME_MAKE(0, TT_NNSEC - 5)))
		return 4;

	if (tt_cmp(tt_reduce(TTIME_MAKE(0, 5 + TT_NNSEC)), TTIME_MAKE(1, 5)))
		return 5;

	if (tt_cmp(tt_reduce(TTIME_MAKE(0, -5 - TT_NNSEC)), TTIME_MAKE(-1, -5)))
		return 6;

	return 0;
}

int
regress_mul()
{
	struct ttime a, b;

	a = TTIME_MAKE(1, TT_NNSEC / 5);
	b = TTIME_MAKE(3, TT_NNSEC * 2 / 5);
	if (tt_cmp(tt_mul(a, b), TTIME_MAKE(4, TT_NNSEC * 2 / 25)) != 0)
		return 1;

	return 0;
}
